/*
 * Decompiled with CFR 0.152.
 */
package moe.ytonidc.dimensional_stomach;

import moe.ytonidc.dimensional_stomach.StomachSlotManager;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StomachCapability {
    public static final Capability<StomachSlotManager> STOMACH_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<StomachSlotManager>(){});
    public static final ResourceLocation CAPABILITY_ID = new ResourceLocation("dimensional_stomach", "stomach_data");

    public static StomachSlotManager getSlotManager(Player player) {
        return (StomachSlotManager)player.getCapability(STOMACH_CAPABILITY).orElseGet(StomachSlotManager::new);
    }

    @Mod.EventBusSubscriber(modid="dimensional_stomach", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public static void registerCapabilities(RegisterCapabilitiesEvent event) {
            event.register(StomachSlotManager.class);
        }
    }

    @Mod.EventBusSubscriber(modid="dimensional_stomach", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeEvents {
        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(STOMACH_CAPABILITY).isPresent()) {
                event.addCapability(CAPABILITY_ID, (ICapabilityProvider)new Provider());
            }
        }

        @SubscribeEvent
        public static void onPlayerClone(PlayerEvent.Clone event) {
            event.getOriginal().reviveCaps();
            event.getOriginal().getCapability(STOMACH_CAPABILITY).ifPresent(oldCap -> event.getEntity().getCapability(STOMACH_CAPABILITY).ifPresent(newCap -> newCap.loadFromNBT(oldCap.saveToNBT())));
            event.getOriginal().invalidateCaps();
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (!player.m_9236_().f_46443_) {
                player.getCapability(STOMACH_CAPABILITY).ifPresent(cap -> cap.applyAttributes(player));
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (!player.m_9236_().f_46443_) {
                player.getCapability(STOMACH_CAPABILITY).ifPresent(cap -> cap.applyAttributes(player));
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (!player.m_9236_().f_46443_) {
                player.getCapability(STOMACH_CAPABILITY).ifPresent(cap -> cap.applyAttributes(player));
            }
        }
    }

    public static class Provider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        private StomachSlotManager slotManager = null;
        private final LazyOptional<StomachSlotManager> optional = LazyOptional.of(this::getOrCreateSlotManager);

        private StomachSlotManager getOrCreateSlotManager() {
            if (this.slotManager == null) {
                this.slotManager = new StomachSlotManager();
            }
            return this.slotManager;
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            if (cap == STOMACH_CAPABILITY) {
                return this.optional.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.getOrCreateSlotManager().saveToNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.getOrCreateSlotManager().loadFromNBT(nbt);
        }

        public void invalidate() {
            this.optional.invalidate();
        }
    }
}

